Hopefully, you now understand how to use Bones for powerful control flow in Bonnie! If you need a refresher, take a look at [this page](./Bones-Syntax). This page will describe how Bones operators work, and how you can use them for even greater control over execution flow in Bonnie!

## Success/Failure

The two most common operators are by far `Success` and `Failure`, which simply allow checking for (unsurprisingly) whether a command succeeded or failed.

## Specific exit codes

Bones also has two operators for looking for specific exit codes. If you want to do something only if a command returns the exit code `6` for example, you would just write `6` as your operator.

If you want to do something for any exit code **other than** a particular one, say `6`, you'd use `!6`, which will match every exit code except 6.

## Any/None

If you want to proceed to another subcommand no matter what happens, you can use the `Any` operator, which will match any exit code.

The opposite is the `None` operator, which has no real purpose for anything whatsoever. It's included to allow verbosity in very complex flows so that you can explicitly say that a certain command will never run in a certain case.

## Unions and Intersections

The last two operators are really metaoperators, they allow you to combine multiple other operators in certain ways to achieve a more complex desired outcome. Their names come from set theory/ The first is a _union_, which is like saying _or_. An intersection says _and_.

Unions are denoted by writing multiple operators and separating them with `|`, with **no spaces**! Intersections use `+` instead.

Right now, unions and intersections can't yet be combined, though this may be introduced in future if there is demand. If you'd like to see this feature in a future release, please [open an issue](https://github.com/arctic-hen7/bonnie/issues/new/choose)!

Intersections may seem a little pointless in Bones, as a command will only ever return one exit code. This is true at the moment, though they've been introduced now to enable support for potentially more complex operators in future (hinting at possible output substring recognition).

## Last Note

Bones is a complex system, and the Bonnie community is here to help if you have questions! Any questions related to new features or bugs should be opened as a [new issue](https://github.com/arctic-hen7/bonnie/issues/new/choose), while any more general queries can be posted on [our Gitter community](https://gitter.im/bonnie-cli)!
